/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspConfigImageSize;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt64;

public class FspLparConfig {
    private static FspLparConfig mInst;
    private static final String GET_LPAR_CONFIGURATION_IMAGE_BLOCK = "GET_LPAR_CONFIGURATION_IMAGE_BLOCK";
    private static final String BLOCK = "BLOCK";
    private static final String CLEAR_LPAR_CONFIGURATION = "CLEAR_LPAR_CONFIGURATION";

    public static FspLparConfig getInstance() {
        if (mInst == null) {
            mInst = new FspLparConfig();
        }
        return mInst;
    }

    private FspLparConfig() {
    }

    byte[] getLparConfigurationBlockCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt64 unsignedInt64, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_LPAR_CONFIGURATION_IMAGE_BLOCK, new String[]{unsignedInt64.toString(), unsignedInt16.toString()});
        return (byte[])hashtable.get(BLOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getLparConfigurationImage(FSPCmdMgr fSPCmdMgr, int n, String string) throws PIHscServerException, PIHscCmdMgrException, IOException {
        boolean bl = true;
        int n2 = 0;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            while (bl && n2 <= n) {
                FspConfigImageSize fspConfigImageSize = null;
                fspConfigImageSize = new FspConfigImageSize().getLparConfigurationImageSizeCmd(fSPCmdMgr);
                int n3 = fspConfigImageSize.getNumberOfBlocks().intValue();
                try {
                    for (int i = 0; i < n3; ++i) {
                        byte[] byArray = this.getLparConfigurationBlockCmd(fSPCmdMgr, fspConfigImageSize.getHandle(), new UnsignedInt16(i));
                        fileOutputStream.write(byArray);
                    }
                }
                catch (PIHscCmdMgrException pIHscCmdMgrException) {
                    pIHscCmdMgrException.printStackTrace();
                    if (bl && n2 <= n) continue;
                    throw pIHscCmdMgrException;
                }
                bl = false;
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    void clearLparConfigurationCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException, PIHscCmdMgrException {
        fSPCmdMgr.doPhypCommand(CLEAR_LPAR_CONFIGURATION, null);
    }
}

